<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('poinbelanjas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained(
                table: 'users',
                indexName: 'poin_user_id'
            )->onDelete('cascade');
            $table->foreignId('member_id')->constrained(
                table: 'members',
                indexName: 'poin_member_id'
            )->onDelete('cascade');
            $table->string('kodetran');
            $table->double('jml_poin');
            $table->enum('sts_poin', ['M', 'K']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('poinbelanjas');
    }
};
